local colr = {LocalBlueColor(1)[1], LocalBlueColor(1)[2], LocalBlueColor(1)[3], 0.25}
local stealth = {LocalBlueColor(1)[1], LocalBlueColor(1)[2], LocalBlueColor(1)[3], 0}
local heck = {
	-- Once upon a time, I tried to make a cube with ActorMultiVertex, but I only ended up creating this instead
	{{0,40,0}, colr}, -- top
	{{40,0,-40}, stealth}, -- right back
	{{40,0,40}, stealth}, -- right front
	{{0,40,0}, colr}, -- top repeat
	{{40,0,40}, stealth}, -- right front repeat
	{{-40,0,40}, stealth}, --left front
	{{0,40,0}, colr}, -- top repeat
	{{-40,0,40}, stealth}, --left front repeat
	{{-40,0,-40}, stealth}, --left back
	{{0,40,0}, colr}, -- top repeat
	{{-40,0,-40}, stealth}, --left back repeat
	{{40,0,-40}, stealth}, -- right back repeat
	-- D:
	{{0,-40,0}, colr}, -- top
	{{40,0,-40}, stealth}, -- right back
	{{40,0,40}, stealth}, -- right front
	{{0,-40,0}, colr}, -- top repeat
	{{40,0,40}, stealth}, -- right front repeat
	{{-40,0,40}, stealth}, --left front
	{{0,-40,0}, colr}, -- top repeat
	{{-40,0,40}, stealth}, --left front repeat
	{{-40,0,-40}, stealth}, --left back
	{{0,-40,0}, colr}, -- top repeat
	{{-40,0,-40}, stealth}, --left back repeat
	{{40,0,-40}, stealth}, -- right back repeat
}
local octo = {
	{{-1,-1,0}, Color.White}, -- topleft
	{{0,-1.4,0}, Color.White},	--
	{{1,-1,0}, Color.White},	-- topright
	{{1.4,0,0}, Color.White},	-- 
	{{1,1,0}, Color.White}, -- bottomright
	{{0,1.4,0}, Color.White},	--
	{{-1,1,0}, Color.White},	-- bottomleft
	{{-1.4,0,0}, Color.White},	--
	{{-1,-1,0}, Color.White},	-- back to topleft	
}

return Def.ActorFrame {
	Def.ActorMultiVertex{
		OnCommand=function(self)
			self:zoomto(30,30):diffuse(LocalBlueColor(0.2)):spin():effectmagnitude(0,0,25)
			
			self:SetNumVertices(#octo):SetLineWidth(3):SetDrawState({Mode="DrawMode_Fan",First=1,Num=-1})
			self:SetVertices(1, octo)
		end
	},
	Def.ActorMultiVertex{
		OnCommand=function(self)
			self:zoomto(24,24):diffuse(LocalBlueColor(0.1)):spin():effectmagnitude(0,0,-25)
			
			self:SetNumVertices(#octo):SetLineWidth(3):SetDrawState({Mode="DrawMode_Fan",First=1,Num=-1})
			self:SetVertices(1, octo)
		end
	},
	Def.ActorMultiVertex{
		OnCommand=function(self)
			self:zoomto(18,18):diffuse(LocalBlueColor(0)):spin():effectmagnitude(0,0,50)
			
			self:SetNumVertices(#octo):SetLineWidth(3):SetDrawState({Mode="DrawMode_Fan",First=1,Num=-1})
			self:SetVertices(1, octo)
		end
	},
	
	Def.ActorMultiVertex{
		OnCommand=function(self)
			self:rotationx(90):spin():effectmagnitude(0,0,50)
		
			self:SetNumVertices(#heck):SetLineWidth(3):SetDrawState({Mode="DrawMode_LineStrip",First=1,Num=-1})
			self:SetVertices(1, heck)
		end
	},
	Def.ActorMultiVertex{
		OnCommand=function(self)
			self:spin():effectmagnitude(0,50,0)
		
			self:SetNumVertices(#heck):SetLineWidth(3):SetDrawState({Mode="DrawMode_LineStrip",First=1,Num=-1})
			self:SetVertices(1, heck)
		end
	},
	Def.ActorFrame{
		OnCommand=function(self) self:spin():effectmagnitude(0,0,-25) end,
		Def.BitmapText{
			Font="Common Normal",
			Text=THEME:GetString("MusicWheel","Portal"),
			OnCommand=function(self) self:zoom(0.3):strokecolor(Color.Black):xy(0,30) end
		},
		Def.BitmapText{
			Font="Common Normal",
			Text=THEME:GetString("MusicWheel","Portal"),
			OnCommand=function(self) self:zoom(0.3):strokecolor(Color.Black):xy(0,-30):rotationz(180) end
		},
		Def.BitmapText{
			Font="Common Normal",
			Text=THEME:GetString("MusicWheel","Portal"),
			OnCommand=function(self) self:zoom(0.3):strokecolor(Color.Black):xy(30,0):rotationz(-90) end
		},
		Def.BitmapText{
			Font="Common Normal",
			Text=THEME:GetString("MusicWheel","Portal"),
			OnCommand=function(self) self:zoom(0.3):strokecolor(Color.Black):xy(-30,0):rotationz(90) end
		},
	}
}
